<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Conversation extends Model 
{

    protected $table = 'conversations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function messages()
    {
        return $this->hasMany('App\Classes\Message');
    }

    public function profiles()
    {
        return $this->belongsToMany('App\Classes\Profile');
    }

}